@extends('admin.template.master')
@section('content')
    <div class="page-content">
        <div class="container-fluid">
            <div class="box-typical box-typical-padding">
                <form action="{{ route('report.special') }}" method="POST">
                    <div class="row">
                        <div class="col-sm-6">
                            @csrf
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label>{{__('messages.start_date')}}</label>
                                    <input type="text" class="form-control datepicker" name="sdate"
                                        value="{{ $sdate }}">
                                </div>
                                <div class="form-group col-md-4 ">
                                    <label>{{__('messages.end_date')}}</label>
                                    <input type="text" class="form-control datepicker" name="edate"
                                        value="{{ $edate }}">
                                </div>
                                <div class="col-md-4">
                                    <button class="btn btn-purple mt-20" type="submit"> {{__('messages.submit')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <div class="row">
                <div class="col">
                    <section class="widget widget-simple-sm">
                        <div class="widget-simple-sm-statistic">
                            <div class="number">{{ formatAmount($total_sales) }}</div>
                            <div class="caption color-blue">{{__('messages.sales')}}</div>
                        </div>
                    </section><!--.widget-simple-sm-->
                </div>
                <div class="col">
                    <section class="widget widget-simple-sm">
                        <div class="widget-simple-sm-statistic">
                            <div class="number">{{ formatAmount($total_expenses) }}</div>
                            <div class="caption color-blue">{{__('messages.expenses')}}</div>
                        </div>
                    </section><!--.widget-simple-sm-->
                </div>
                <div class="col">
                    <section class="widget widget-simple-sm">
                        <div class="widget-simple-sm-statistic">
                            <div class="number">{{ formatAmount($total_purchases) }}</div>
                            <div class="caption color-blue">{{__('messages.purchases')}}</div>
                        </div>
                    </section><!--.widget-simple-sm-->
                </div>
                <div class="col">
                    <section class="widget widget-simple-sm">
                        <div class="widget-simple-sm-statistic">
                            <div class="number">{{ formatAmount($total_returns) }}</div>
                            <div class="caption color-blue">{{__('messages.returns')}}</div>
                        </div>
                    </section><!--.widget-simple-sm-->
                </div>
                <div class="col">
                    <section class="widget widget-simple-sm">
                        <div class="widget-simple-sm-statistic">
                            <div class="number">{{ formatAmount($difference) }}</div>
                            <div class="caption color-blue">{{__('messages.difference')}}</div>
                        </div>
                    </section><!--.widget-simple-sm-->
                </div>
            </div>


        </div><!--.page-content-->
    @endsection
    @section('customjs')
        <script src="{{ asset('custom_js/reports.js') }}"></script>
    @endsection
