<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transfers extends Model
{
    protected $table = 'transfers';
    public $timestamps = false;
    protected $fillable = [
        'notes',
        'dated',
    ];  

    public function branchFrom()
    {
        return $this->belongsTo(Branches::class, 'branch_id_from', 'branch_id');
    }
    public function branchTo()
    {
        return $this->belongsTo(Branches::class, 'branch_id', 'branch_id');
    }
    public function branch()
    {
        return $this->belongsTo(Branches::class, 'branch_id', 'branch_id');
    }
}
