<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Quotations extends Model
{
    protected $table = 'quotations';
    public $timestamps = false;  
    protected $fillable = [
        'branch_id',
        'invoice',
        'type',
        'customer_id',
        'purchases',
        'items_subtotal',
        'services_subtotal',
        'sub_total',
        'payment_type',
        'discount',
        'grand_total',
        'advance',
        'payments',
        'delivery_date',
        'notes',
        'points_discount',
        'dated',
    ];

    public function quotationDetails(){
        return $this->hasMany(QuotationDetails::class, 'invoice', 'invoice');
    }
    public function customer() {
        return $this->belongsTo(Customers::class, 'customer_id', 'customer_id');
    }
}
