<?php
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Http;

if (!function_exists('formatAmount')) {
    function formatAmount($amount, $decimals = 3)
    {
        return number_format($amount, $decimals);
    }
}


if (!function_exists('pageTitle')) {
    function pageTitle($string = null)
    {
        if ($string) {
            return Str::lower($string);
        }  
        return Str::lower(last(request()->segments()));
    }
}


if (!function_exists('dailyQoutes')) {
    function dailyQoutes()
    {
        $response = Http::get('https://zenquotes.io/api/today');
        return $response->json()[0]['q'] ?? '';
    }
}


