
<?php $__env->startSection('content'); ?>
    <div class="page-content">
        <div class="container-fluid">
            <div class="box-typical box-typical-padding">
                <form action="<?php echo e(route('report.expenses')); ?>" method="POST">
                    <div class="row">
                        <div class="col-sm-6">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="form-group col-md-3">
                                    <label><?php echo e(__('messages.start_date')); ?></label>
                                    <input type="text" class="form-control datepicker" name="sdate"
                                        value="<?php echo e($sdate); ?>">
                                </div>
                                <div class="form-group col-md-3">
                                    <label><?php echo e(__('messages.end_date')); ?></label>
                                    <input type="text" class="form-control datepicker" name="edate"
                                        value="<?php echo e($edate); ?>">
                                </div>
                                <div class="form-group col-md-3">
                                    <label><?php echo e(__('messages.category')); ?></label>
                                    <select name="expense_category" class="form-control">
                                        <option value="" selected> <?php echo e(__('messages.choose')); ?> </option>
                                        <?php $__currentLoopData = $expense_category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($expc->category_id == $sexpense_category): ?>
                                                <option value="<?php echo e($expc->category_id); ?>" selected><?php echo e($expc->category_name); ?>

                                                </option>
                                            <?php else: ?>
                                                <option value="<?php echo e($expc->category_id); ?>"><?php echo e($expc->category_name); ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <button class="btn btn-purple mt-20" type="submit"> <?php echo e(__('messages.submit')); ?></button>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="row">
                                <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $br): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($branch_ids != ''): ?>
                                        <?php if(in_array($br->branch_id, $branch_ids)): ?>
                                            <div class="col-md-2">
                                                <input type="checkbox" name="brnchk[]" class=""
                                                    value="<?php echo e($br->branch_id); ?>" checked> <?php echo e($br->branch_name); ?>

                                            </div>
                                        <?php else: ?>
                                            <div class="col-md-2">
                                                <input type="checkbox" name="brnchk[]" class=""
                                                    value="<?php echo e($br->branch_id); ?>"> <?php echo e($br->branch_name); ?>

                                            </div>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <div class="col-md-2">
                                            <input type="checkbox" name="brnchk[]" class=""
                                                value="<?php echo e($br->branch_id); ?>"> <?php echo e($br->branch_name); ?>

                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="box-typical box-typical-padding">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table MyTable" id="reportExpenseTable">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th><?php echo e(__('messages.date')); ?></th>
                                    <th><?php echo e(__('messages.branch')); ?></th>
                                    <th><?php echo e(__('messages.category')); ?></th>
                                    <th><?php echo e(__('messages.title')); ?></th>
                                    <th><?php echo e(__('messages.notes')); ?></th>
                                    <th><?php echo e(__('messages.amount')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $total = 0;
                                ?>
                                <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e(date('d-m-Y', strtotime($exp->exp_date))); ?></td>
                                        <td><?php echo e($exp->branch->branch_name??'General'); ?></td>
                                        <td><?php echo e($exp->category->category_name??'Try'); ?></td>
                                        <td><?php echo e($exp->title); ?></td>
                                        <td><?php echo e($exp->notes); ?></td>
                                        <td class="text-right"><?php echo e(number_format($exp->exp_amount, 3)); ?></td>
                                        <?php
                                            $total += $exp->exp_amount;
                                        ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th><?php echo e($total); ?></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div><!--.container-fluid-->
            <div id="trf-details" class="modal fade" role="dialog">
                <div class="modal-dialog modal-lg">
                    <!-- Modal content-->
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="modal-close" data-dismiss="modal">
                                <i class="font-icon-close-2"></i>
                            </button>
                            <h4 class="modal-title"><?php echo e(__('messages.transfer')); ?> # : <span id="invoice_number"></span></h4>
                        </div>
                        <div class="modal-body" id="trf-mbody">

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('messages.close')); ?></button>
                        </div>
                    </div>
                </div>
            </div>
        </div><!--.page-content-->
    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('customjs'); ?>
        <script src="<?php echo e(asset('custom_js/reports.js')); ?>"></script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.template.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/craftada/iftikhar.appssoul.com/resources/views/admin/report_expenses.blade.php ENDPATH**/ ?>