<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Big Wishes | Admin Login</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import  url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600&family=Comic+Neue:wght@400;700&display=swap');

        body {
            font-family: 'Inter', sans-serif;
            background-color: #f9f5f0;
            background-image: url("data:image/svg+xml,%3Csvg width='100' height='100' viewBox='0 0 100 100' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M11 18c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm48 25c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm-43-7c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm63 31c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM34 90c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm56-76c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM12 86c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm28-65c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm23-11c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-6 60c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm29 22c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zM32 63c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm57-13c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-9-21c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM60 91c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM35 41c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM12 60c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2z' fill='%23e2d5c3' fill-opacity='0.3' fill-rule='evenodd'/%3E%3C/svg%3E");
        }

        .doodle-icon {
            font-family: 'Comic Neue', cursive;
        }
    </style>
</head>

<body class="min-h-screen flex items-center justify-center p-4">
    <!-- Book Icons Floating in Background -->
    <div class="fixed inset-0 overflow-hidden -z-10 opacity-20">
        <div class="absolute top-1/4 left-10 text-6xl doodle-icon" style="transform: rotate(-15deg);">📚</div>
        <div class="absolute bottom-1/3 right-20 text-5xl doodle-icon" style="transform: rotate(10deg);">📖</div>
        <div class="absolute top-20 right-1/4 text-7xl doodle-icon" style="transform: rotate(5deg);">🖋️</div>
        <div class="absolute bottom-20 left-1/3 text-6xl doodle-icon" style="transform: rotate(-10deg);">✏️</div>
    </div>

    <div class="w-full max-w-md relative">
        <!-- Logo with Book Icon -->
        <div class="text-center mb-8">
            <div class="inline-flex items-center justify-center bg-amber-100 rounded-full p-4 shadow-md">
                 <img src="<?php echo e(asset('img/bigt.png')); ?>" width="200" height="200" alt="Big wishes"/> 
            </div>
        </div>
        <?php if($errors->any()): ?>
            <!-- Error Message Container - Place at the top of your form -->
            <div class="mb-4 p-4 rounded-lg bg-red-50 border-l-4 border-red-500">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-red-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                            fill="currentColor">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                clip-rule="evenodd" />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-medium text-red-800">Invalid Credentials</h3>

                    </div>
                </div>
            </div>
        <?php endif; ?>
        <!-- Login Form -->
        <form method="POST" action="<?php echo e(route('loginAdmin')); ?>"
            class="bg-white/90 backdrop-blur-sm rounded-xl shadow-lg p-8 border border-amber-100/30">
            <?php echo csrf_field(); ?>
            <div class="space-y-6">
                <!-- Branch Dropdown -->

                <!-- Username Field -->
                <div>
                    <label for="username" class="block text-sm font-medium text-gray-700 mb-1 flex items-center">
                        <span class="text-xl mr-2 doodle-icon">👤</span> Username
                    </label>
                    <input type="text" name="username" id="username" required
                        class="w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-amber-500 focus:border-amber-500 transition"
                        placeholder="Username">
                </div>

                <!-- Password Field -->
                <div>
                    <label for="password" class="block text-sm font-medium text-gray-700 mb-1 flex items-center">
                        <span class="text-xl mr-2 doodle-icon">🔒</span> Password
                    </label>
                    <input type="password" name="password" id="password" required
                        class="w-full px-4 py-3 rounded-lg border border-gray-300 focus:ring-2 focus:ring-amber-500 focus:border-amber-500 transition"
                        placeholder="Password">
                </div>

                <!-- Submit Button -->
                <button type="submit"
                    class="w-full py-3 px-4 bg-amber-600 hover:bg-amber-700 text-white font-medium rounded-lg transition duration-200 shadow-md hover:shadow-lg flex items-center justify-center">
                    <span class="text-xl mr-2 doodle-icon">🔑</span> Sign In
                </button>
            </div>
        </form>

        <!-- Footer Doodle -->
        <div class="text-center mt-6 text-gray-500 text-sm flex justify-center">
            <span class="doodle-icon mr-2">📚</span>
            <span>Every book is a new adventure</span>
            <span class="doodle-icon ml-2">📖</span>
        </div>
    </div>
</body>

</html>
<?php /**PATH D:\Freelance\BigWishes\work\resources\views/auth/admin_login.blade.php ENDPATH**/ ?>