
<?php $__env->startSection('content'); ?>
    <div class="page-content">
        <div class="container-fluid">
            <div class="box-typical box-typical-padding">
                <div class="row">
                    <div class="col-md-12">
                        <p id="exp_err_msg"></p>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="expense_category"><?php echo e(__('messages.expense_category')); ?></label>
                            <select class="form-control" id="expense_category" name="expense_category">
                                <option value="" selected> <?php echo e(__('messages.choose')); ?> </option>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($ec->category_id); ?>"><?php echo e($ec->category_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="expense_branch"><?php echo e(__('messages.branch')); ?> </label>
                            <select class="form-control" id="expense_branch" name="expense_branch">
                                <option value="" selected> <?php echo e(__('messages.choose')); ?> </option>
                                <option value="0"><?php echo e(__('messages.general')); ?></option>
                                <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $br): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($br->branch_id); ?>"><?php echo e($br->branch_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="expense_title"><?php echo e(__('messages.title')); ?> </label>
                            <input type="text" class="form-control" id="expense_title" name="expense_title"
                                placeholder="Title">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="expense_amount"><?php echo e(__('messages.amount')); ?></label>
                            <input type="text" class="form-control isnumber" id="expense_amount" name="expense_amount"
                                placeholder="Amount">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="expense_date"><?php echo e(__('messages.date')); ?></label>
                            <input type="text" class="form-control datepicker" id="expense_date" name="expense_date"
                                placeholder="yyyy-mm-dd">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="payment_type"><?php echo e(__('messages.payment_type')); ?> </label>
                            <select class="form-control" id="payment_type" name="payment_type">
                                <option value="" selected> S<?php echo e(__('messages.choose')); ?> </option>
                                <option value="cash"> <?php echo e(__('messages.cash')); ?> </option>
                                <option value="cheque"> <?php echo e(__('messages.cheque')); ?> </option>
                                <option value="card"> <?php echo e(__('messages.card')); ?> </option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="expense_title"><?php echo e(__('messages.cheque')); ?> # </label>
                            <input type="text" class="form-control" id="cheque_number" name="cheque_number"
                                placeholder="Cheque Number">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="expense_notes"><?php echo e(__('messages.notes')); ?></label>
                            <textarea class="form-control" id="expense_notes" name="expense_notes" placeholder="Notes"></textarea>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <input type="button" class="btn btn-info m-t-10" id="btn_add_expense" name="btn_add_expense"
                                value="<?php echo e(__('messages.add')); ?>">
                        </div>
                    </div>
                </div>
            </div>
            <div class="box-typical box-typical-padding">
                <table id="expensesTable" class="table table-striped table-bordered dt-responsive nowrap" cellspacing="0"
                    width="100%">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo e(__('messages.branch')); ?></th>
                            <th><?php echo e(__('messages.category')); ?></th>
                            <th><?php echo e(__('messages.title')); ?></th>
                            <th><?php echo e(__('messages.date')); ?></th>
                            <th><?php echo e(__('messages.amount')); ?></th>
                            <th><?php echo e(__('messages.payment_type')); ?></th>
                            <th><?php echo e(__('messages.cheque')); ?> #</th>
                            <th><?php echo e(__('messages.notes')); ?></th>
                            <th><?php echo e(__('messages.date/time')); ?></th>
                            <th><?php echo e(__('messages.actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>

                    </tbody>

                </table>
            </div>
        </div><!--.container-fluid-->
        <div id="expense-edit-modal" class="modal fade" role="dialog">
            <div class="modal-dialog">
                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="modal-close" data-dismiss="modal">
                            <i class="font-icon-close-2"></i>
                        </button>
                        <h4 class="modal-title"><?php echo e(__('messages.edit')); ?></h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <p id="e_exp_err_msg"></p>
                            </div>
                            <div class="col-md-6">

                                <input type="hidden" name="exp_id" id="e_exp_id">
                                <div class="form-group">
                                    <label for="e_expense_category"><?php echo e(__('messages.expense_category')); ?> </label>
                                    <select class="form-control" id="e_expense_category" name="expense_category">
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($ec->category_id); ?>"><?php echo e($ec->category_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="e_expense_branch"><?php echo e(__('messages.branch')); ?> </label>
                                    <select class="form-control" id="e_expense_branch" name="expense_branch">
                                        <option value="0"><?php echo e(__('messages.general')); ?></option>
                                        <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $br): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($br->branch_id); ?>"><?php echo e($br->branch_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-12">
                                <label for="expense_title"><?php echo e(__('messages.title')); ?></label>
                                <input type="text" class="form-control" id="e_expense_title" name="expense_title"
                                    placeholder="Title">
                            </div>
                            <div class="form-group col-md-12">
                                <label for="expense_amount"><?php echo e(__('messages.amount')); ?></label>
                                <input type="text" class="form-control isnumber" id="e_expense_amount"
                                    name="expense_amount" placeholder="Amount">
                            </div>
                            <div class="form-group col-md-12">
                                <label for="expense_date"><?php echo e(__('messages.date')); ?></label>
                                <input type="text" class="form-control datepicker" id="e_expense_date"
                                    name="expense_date" placeholder="yyyy-mm-dd">
                            </div>
                            <div class="form-group col-md-12">
                                <label for="expense_notes"><?php echo e(__('messages.notes')); ?></label>
                                <textarea class="form-control" id="e_expense_notes" name="e_expense_notes" placeholder="Notes"></textarea>
                            </div>
                        </div>
                        <span id="e_item-msg"></span>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('messages.close')); ?></button>
                        <button type="button" id="btn_update_expense" class="btn btn-primary waves-effect waves-light"><?php echo e(__('messages.save_changes')); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div><!--.page-content-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('customjs'); ?>
    <script src="<?php echo e(asset('custom_js/expenses.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.template.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/craftada/iftikhar.appssoul.com/resources/views/admin/expenses.blade.php ENDPATH**/ ?>