@extends('admin.template.master')
@section('content')
    <div class="page-content">
        <div class="container-fluid">
            <div class="box-typical box-typical-padding">
                <form action="{{ route('report.transfers') }}" method="POST">
                    <div class="row">
                        <div class="col-sm-6">
                            @csrf
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label>{{__('messages.start_date')}}</label>
                                    <input type="text" class="form-control datepicker" name="sdate"
                                        value="{{ $sdate }}">
                                </div>
                                <div class="form-group col-md-4 ">
                                    <label>{{__('messages.end_date')}}</label>
                                    <input type="text" class="form-control datepicker" name="edate"
                                        value="{{ $edate }}">
                                </div>
                                <div class="col-md-4">
                                    <button class="btn btn-purple mt-20" type="submit"> {{__('messages.submit')}}</button>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="row">
                                @foreach ($branches as $br)
                                    @if ($branch_ids != '')
                                        @if (in_array($br->branch_id, $branch_ids))
                                            <div class="col-md-2">
                                                <input type="checkbox" name="brnchk[]" class=""
                                                    value="{{ $br->branch_id }}" checked> {{ $br->branch_name }}
                                            </div>
                                        @else
                                            <div class="col-md-2">
                                                <input type="checkbox" name="brnchk[]" class=""
                                                    value="{{ $br->branch_id }}"> {{ $br->branch_name }}
                                            </div>
                                        @endif
                                    @else
                                        <div class="col-md-2">
                                            <input type="checkbox" name="brnchk[]" class=""
                                                value="{{ $br->branch_id }}"> {{ $br->branch_name }}
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="box-typical box-typical-padding">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table MyTable" id="transfersTable">
                            <thead>
                                <tr>
                                    <th> # </th>
                                    <th> {{__('messages.date/time')}} </th>
                                    <th> {{__('messages.start_date')}} </th>
                                    <th> {{__('messages.invoice')}} </th>
                                    <th> {{__('messages.total_items')}}</th>
                                </tr>
                            </thead>
                            <tbody>

                                @php
                                    $total_items = 0;
                                @endphp
                                @foreach ($transfers as $trf)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $trf->dated }}</td>
                                        <td>{{ $trf->branch->branch_name }}</td>
                                        <td>
                                            <a href="#" id="{{ $trf->invoice }}" data-toggle="modal" data-target="#trf-details">{{ $trf->invoice }}</a>
                                        </td>
                                        <td class="total_st">{{ intval($trf->total_items) }}</td>
                                    </tr>
                                    @php
                                        $total_items += $trf->total_items;
                                    @endphp
                                @endforeach

                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>{{ intval($total_items) }}</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div><!--.container-fluid-->
             <div id="trf-details" class="modal fade" role="dialog">
                <div class="modal-dialog modal-lg">
                    <!-- Modal content-->
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="modal-close" data-dismiss="modal">
                                <i class="font-icon-close-2"></i>
                            </button>
                            <h4 class="modal-title">{{__('messages.transfer')}} # : <span id="invoice_number"></span></h4>
                        </div>
                        <div class="modal-body" id="trf-mbody">

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">{{__('messages.close')}}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div><!--.page-content-->
    @endsection
    @section('customjs')
        <script src="{{ asset('custom_js/reports.js') }}"></script>
    @endsection
