@extends('admin.template.master')
@section('content')
    <div class="page-content">
        <div class="container-fluid">
            <div class="box-typical box-typical-padding">
                <form action="{{ route('report.stock-in') }}" method="POST">
                    <div class="row">
                        <div class="col-sm-6">
                            @csrf
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label>{{__('messages.start_date')}}</label>
                                    <input type="text" class="form-control datepicker" name="sdate"
                                        value="{{ $sdate }}">
                                </div>
                                <div class="form-group col-md-4 ">
                                    <label>{{__('messages.end_date')}}</label>
                                    <input type="text" class="form-control datepicker" name="edate"
                                        value="{{ $edate }}">
                                </div>
                                <div class="col-md-4">
                                    <button class="btn btn-purple mt-20" type="submit"> {{__('messages.submit')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="box-typical box-typical-padding">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table MyTable">
                            <thead>
                                <tr>
                                    <th> # </th>
                                    <th> {{__('messages.date')}}</th>
                                    <th> {{__('messages.items')}} </th>
                                    <th> {{__('messages.quantity')}} </th>
                                    <th> {{__('messages.notes')}} </th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach ($stock_in as $si)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $si->stk_date }}</td>
                                        <td>{{ $si->item->stk_name }}-{{ $si->stk_item }}</td>
                                        <td>{{ str_replace(',', '', number_format($si->stk_quantity)) }}</td>
                                        <td>{{ $si->stk_notes }}</td>
                                    </tr>
                                @endforeach


                            </tbody>
                            <tfoot>
                                <th>&nbsp;</th>
                                <th>&nbsp;</th>
                                <th>&nbsp;</th>
                                <th>&nbsp;</th>
                                <th>&nbsp;</th>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div><!--.container-fluid-->

        </div><!--.page-content-->
    @endsection
    @section('customjs')
        <script src="{{ asset('custom_js/reports.js') }}"></script>
    @endsection
