@extends('admin.template.master')
@section('content')
    <div class="page-content">
        <div class="container-fluid">
            <div class="box-typical box-typical-padding">
                <form action="{{ route('report.sales') }}" method="POST">
                    <div class="row">
                        <div class="col-sm-6">
                            @csrf
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label>{{__('messages.start_date')}}</label>
                                    <input type="text" class="form-control datepicker" name="sdate"
                                        value="{{ $sdate }}">
                                </div>
                                <div class="form-group col-md-4 ">
                                    <label>End Date</label>
                                    <input type="text" class="form-control datepicker" name="edate"
                                        value="{{ $edate }}">
                                </div>
                                <div class="col-md-4">
                                    <button class="btn btn-purple mt-20" type="submit"> Submit</button>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="row">
                                @foreach ($branches as $br)
                                    @if ($branch_ids != '')
                                        @if (in_array($br->branch_id, $branch_ids))
                                            <div class="col-md-2">
                                                <input type="checkbox" name="brnchk[]" class=""
                                                    value="{{ $br->branch_id }}" checked> {{ $br->branch_name }}
                                            </div>
                                        @else
                                            <div class="col-md-2">
                                                <input type="checkbox" name="brnchk[]" class=""
                                                    value="{{ $br->branch_id }}"> {{ $br->branch_name }}
                                            </div>
                                        @endif
                                    @else
                                        <div class="col-md-2">
                                            <input type="checkbox" name="brnchk[]" class=""
                                                value="{{ $br->branch_id }}"> {{ $br->branch_name }}
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="box-typical box-typical-padding">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table" id="salesTable">
                            <thead>
                                <tr>
                                    <th> S.no </th>
                                    <th> Date/Time </th>
                                    <th> Branch </th>
                                    <th> Invoice </th>
                                    <th> Payment Type </th>
                                    <th> Sub Total </th>
                                    <th> Discount </th>
                                    <th> Grand Total </th>
                                    <th> Purchases </th>
                                    <th> Difference </th>
                                    <th> Invoice </th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $sno = 0;
                                    $total_st = 0;
                                    $total_ds = 0;
                                    $total_gt = 0;
                                    $total_ph = 0;
                                @endphp
                                @foreach ($sales as $sls)
                                    @php$sno++;@endphp
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $sls->dated }}</td>
                                        <td>{{ $sls->branch->branch_name }}</td>
                                        <td>
                                            <a href="#" id="{{ $sls->invoice }}" data-toggle="modal"
                                                data-target="#sinvoice-details">{{ $sls->invoice }}</a>
                                        </td>
                                        <td>{{ $sls->payment_type }}</td>
                                        <td class="total_st">{{ $sls->sub_total }}</td>
                                        <td class="total_ds">{{ $sls->discount }}</td>
                                        <td class="total_gt">{{ $sls->grand_total }}</td>
                                        <td class="total_ph">{{ $sls->purchases }}</td>
                                        <td class="total_diff">{{ formatAmount($sls->grand_total - $sls->purchases) }}
                                        </td>
                                        <td><a href="{{ route('sales.invoice', ['id' => $sls->invoice]) }}"
                                                target="_blank"><i class="fa fa-print"></i></a></td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th class="text-purple" id="total_st"></th>
                                    <th class="text-warning" id="total_ds"></th>
                                    <th class="text-success" id="total_gt"></th>
                                    <th class="text-danger" id="total_ph"></th>
                                    <th class="text-info" id="total_diff"></th>
                                    <th>&nbsp;</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div><!--.container-fluid-->
            <div id="sinvoice-details" class="modal fade" role="dialog">
                <div class="modal-dialog modal-lg">
                    <!-- Modal content-->
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="modal-close" data-dismiss="modal">
                                <i class="font-icon-close-2"></i>
                            </button>
                            <h4 class="modal-title">Invoice : <span id="invoice_number"></span></h4>
                        </div>
                        <div class="modal-body" id="sinvoice-mbody">

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
        </div><!--.page-content-->
    @endsection
    @section('customjs')
        <script src="{{ asset('custom_js/reports.js') }}"></script>
    @endsection
