@extends('admin.template.master')
@section('content')
    <div class="page-content">
        <div class="container-fluid">
            <div class="box-typical box-typical-padding">
                <form action="{{ route('report.sales') }}" method="POST">
                    <div class="row">
                        <div class="col-sm-6">
                            @csrf
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label>{{__('messages.start_date')}}</label>
                                    <input type="text" class="form-control datepicker" name="sdate"
                                        value="{{ $sdate }}">
                                </div>
                                <div class="form-group col-md-4 ">
                                    <label>{{__('messages.end_date')}}</label>
                                    <input type="text" class="form-control datepicker" name="edate"
                                        value="{{ $edate }}">
                                </div>
                                <div class="col-md-4">
                                    <button class="btn btn-purple mt-20" type="submit"> {{__('messages.submit')}}</button>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="row">
                                @foreach ($branches as $br)
                                    @if ($branch_ids != '')
                                        @if (in_array($br->branch_id, $branch_ids))
                                            <div class="col-md-2">
                                                <input type="checkbox" name="brnchk[]" class=""
                                                    value="{{ $br->branch_id }}" checked> {{ $br->branch_name }}
                                            </div>
                                        @else
                                            <div class="col-md-2">
                                                <input type="checkbox" name="brnchk[]" class=""
                                                    value="{{ $br->branch_id }}"> {{ $br->branch_name }}
                                            </div>
                                        @endif
                                    @else
                                        <div class="col-md-2">
                                            <input type="checkbox" name="brnchk[]" class=""
                                                value="{{ $br->branch_id }}"> {{ $br->branch_name }}
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="box-typical box-typical-padding">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table m-0 MyTable" id="reportExpenseTable">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>{{__('messages.category')}}</th>
                                    <th>{{__('messages.amount')}}</th>
                                    <th>{{__('messages.percentage')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($report as $row)
                                    <tr>
                                        <td>{{ $row['sno'] }}</td>
                                        <td>{{ $row['category_name'] }}</td>
                                        <td>{{ number_format($row['category_total'], 2) }}</td>
                                        <td>{{ $row['percentage'] }}%</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>{{ number_format($total_percentage, 3)}}</th>
                                    <th>{{ number_format($totalSales)}}</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div><!--.container-fluid-->

        </div><!--.page-content-->
    @endsection
    @section('customjs')
        <script src="{{ asset('custom_js/reports.js') }}"></script>
    @endsection
