$(document).ready(function(){
	$('.ifnotify2').trigger('click');
	// Datepicker 
	$('.datepicker').datepicker({dateFormat:'yy-mm-dd'});
	$('#employeesTable').DataTable({
    	 "sAjaxSource": base_url+'employees/show_employees',
    	 "pageLength": 10,
    	 "order": [],
    	 "responsive":true
    });

    
    $('#btn-add-employees').on('click',function(e){
        $('#emp-msg').fadeOut('slow');
        $('#emp-msg').removeClass();
        var branch_id = $('#branch_id').val();
        var employee_name = $('#employee_name').val();
        var employee_contact = $('#employee_contact').val();
        var employee_commission = $('#employee_commission').val();
        var employee_email = $('#employee_email').val();
        var employee_address = $('#employee_address').val();
        var employee_notes = $('#employee_notes').val();
        if(branch_id=="")
        {
            $('#emp-msg').html('Please Select Branch').addClass('text-warning').fadeIn('slow');
            return false;
        }
        if(employee_name=="")
        {
            $('#emp-msg').html('Please provide Name').addClass('text-warning').fadeIn('slow');
            return false;
        }
        if(employee_contact=="")
        {
            $('#emp-msg').html('Please provide Contact').addClass('text-warning').fadeIn('slow');
            return false;
        }
        if(employee_commission=="")
        {
            $('#emp-msg').html('Please provide Commission').addClass('text-warning').fadeIn('slow');
            return false;
        }
        // if(employee_email=="")
        // {
        //     $('#emp-msg').html('Please provide Email').addClass('text-warning').fadeIn('slow');
        //     return false;
        // }
        if(employee_address=="")
        {
            employee_address='N/A';
        }
        if(employee_notes=="")
        {
            employee_notes = 'N/A';
        }
        
        $.ajax({
            url:base_url+'employees/add_employees',
            type:'POST',
            data:{branch_id:branch_id,employee_name:employee_name,employee_contact:employee_contact,employee_commission:employee_commission,employee_email:employee_email,employee_address:employee_address,employee_notes:employee_notes},
            success:function(response)
            {
                if(response==1)
                {
                    $('#ifnotify-success').text(' Added');
                    $('#ifnotify-success').trigger('click');
                    $('#branch_id').val("");
                    $('#employee_name').val("");
                    $('#employee_contact').val("");
                    $('#employee_commission').val("");
                    $('#employee_email').val("");
                    $('#employee_address').val("");
                    $('#employee_notes').val("");
                }
                else if(response==2)
                {
                    $('#ifnotify-warning').text(' Contact already exists');
                    $('#ifnotify-warning').trigger('click');
                }
                else if(response==0)
                {
                    $('#ifnotify-error').text(' Error try again');
                    $('#ifnotify-error').trigger('click');
                }
                else
                {   
                    $('#ifnotify-warning').text(response);
                    $('#ifnotify-warning').trigger('click');
                }
                $('#employeesTable').DataTable().ajax.reload();
            }
        });
    });

    $('#employees-edit-modal').on('show.bs.modal',function(e){
        var employee_id = e.relatedTarget.id;
        $('#e_emp-msg').html("");
        $('#e_employee_id').val(employee_id);
        $.ajax({
            url:base_url+'employees/get_employees',
            type:'POST',
            data:{employee_id:employee_id},
            success:function(msg)
            {
                var res = $.parseJSON(msg);
                if(res[0]==0){res[0]="";}
                $('#e_branch_id').val(res[0]);   
                $('#e_employee_name').val(res[1]);   
                $('#e_employee_contact').val(res[2]);
                $('#e_employee_commission').val(res[3]);
                $('#e_employee_email').val(res[4]);
                $('#e_employee_address').val(res[5]);
                $('#e_employee_notes').val(res[6]);
            }
        });
    });

    $('#btn-update-employees').on('click',function(e){   
        $('#e_emp-msg').fadeOut('slow');
        $('#e_emp-msg').removeClass();
        var employee_id = $('#e_employee_id').val();
        var branch_id = $('#e_branch_id').val();
        var employee_name = $('#e_employee_name').val();
        var employee_contact = $('#e_employee_contact').val();
        var employee_commission = $('#e_employee_commission').val();
        var employee_email = $('#e_employee_email').val();
        var employee_address = $('#e_employee_address').val();
        var employee_notes = $('#e_employee_notes').val();
        if(branch_id=="")
        {
            $('#emp-msg').html('Please Select Branch').addClass('text-warning').fadeIn('slow');
            return false;
        }
        if(employee_name=="")
        {
            $('#e_emp-msg').html('Please provide Name').addClass('text-warning').fadeIn('slow');
            return false;
        }
        if(employee_contact=="")
        {
            $('#e_emp-msg').html('Please provide Contact').addClass('text-warning').fadeIn('slow');
            return false;
        }
        if(employee_commission=="")
        {
            $('#e_emp-msg').html('Please provide Commission').addClass('text-warning').fadeIn('slow');
            return false;
        }
        // if(employee_email=="")
        // {
        //     $('#e_emp-msg').html('Please provide Email').addClass('text-warning').fadeIn('slow');
        //     return false;
        // }
        if(employee_address=="")
        {
            employee_address='N/A';
        }
        if(employee_notes=="")
        {
            employee_notes = 'N/A';
        }
        $.ajax({
            url:base_url+'employees/update_employees',
            type:'POST',
            data:{employee_id:employee_id,branch_id:branch_id,employee_name:employee_name,employee_email:employee_email,employee_contact:employee_contact,employee_commission:employee_commission,employee_address:employee_address,employee_notes:employee_notes},
            success:function(response)
            {
                if(response==1)
                {

                    $('#ifnotify-success').text(' Updated');
                    $('#ifnotify-success').trigger('click');
                }
                else if(response==2)
                {
                    $('#ifnotify-warning').text('Nothing to update');
                    $('#ifnotify-warning').trigger('click');
                }
                else if(response==3)
                {
                    $('#ifnotify-warning').text(' Contact already exists');
                    $('#ifnotify-warning').trigger('click');
                }
                else if(response==0)
                {
                    $('#ifnotify-error').text(' Error try again');
                    $('#ifnotify-error').trigger('click');
                }
                else
                {
                    $('#ifnotify-warning').text(response);
                    $('#ifnotify-warning').trigger('click');
                }
                $('#employeesTable').DataTable().ajax.reload();
            }
        });
    });

    $('#employeesTable').on('click','.ifdel',function(e){
        e.preventDefault();
        var href = $(this).attr('href');
        if(typeof(href) != "undefined" && href !== null)
        {
          swal({
              title:"Are you sure?",
              text: "You will not be able to recover this data!",
              type: "warning",
              showCancelButton: true,
              confirmButtonClass: 'btn-danger btn-md waves-effect waves-light',
              confirmButtonColor: "#DD6B55",
              confirmButtonText: "Yes, delete it!",
              cancelButtonText: "No, cancel it!",
              closeOnConfirm: true,
              closeOnCancel: true
          }, function (isConfirm) {
              if (isConfirm) 
              {
                window.location=href;
              } 
              else 
              {
                  return false;
              }
          });
        }
    });

    
    $('#employees-invoices-modal').on('show.bs.modal',function(e){
    	var employees_id = e.relatedTarget.id;
    	$.ajax({
    		url:base_url+'employees/get_employees_invoices',
    		type:'POST',
    		data:{employees_id:employees_id},
    		success:function(msg)
    		{
    			var res = $.parseJSON(msg);
    			$('#pinv-mbody').html("");
    			$('#pinv-mbody').html(res[0]);
    		}
    	});
    });

    $('#make-payment-modal').on('show.bs.modal',function(e){
    	var invoice = e.relatedTarget.id;
    	var amount  = parseFloat(e.relatedTarget.getAttribute('href'));
    	var advance = parseFloat(e.relatedTarget.getAttribute('title'));
        $('#invoice_number').html("");
    	$('#invoice_number').html(invoice);
    	$('#payment-tbody').html("");
    	$('#payment-tbody').html('<tr><td></td><td></td><td class="pamount">'+amount+'</td></tr>');
    	if(advance>0)
    	{
    		$('#payment-tbody').append('<tr><td></td><td class="adv">'+advance+'</td><td class="pamount">'+(amount-advance)+'</td><td></td></tr>')	
    	}
    	amount = (amount-advance);
    	recalcId();
    	$.ajax({
    		url:base_url+'employees/get_employees_payments',
    		type:'POST',
    		data:{invoice:invoice,amount:amount,advance:advance},
    		success:function(msg)
    		{
    			var res = $.parseJSON(msg);
    			$('#payment-tbody').append(res[0]);
    			recalcId();
    		}	
    	});
    });

    $('#ptext').on('keyup',function(e){
    	var amount  = parseFloat($('.pamount:last').text());
    	var pamount = parseFloat($(this).val());
    	if(pamount>amount)
    	{
    		$('#ifnotify-warning').text(' Amount must be less or equal last payment');
    		$('#ifnotify-warning').trigger('click');
    		return false;
    	}
    });

    $("#btn-make-payment").on('click',function(e){
    	var famount  = parseFloat($('.pamount:first').text());
    	var amount  = parseFloat($('.pamount:last').text());
    	var pamount = parseFloat($('#ptext').val());
    	var advance = parseFloat($('.adv').text());
       if(isNaN(pamount)){pamount=0;}
    	if(pamount==0)
    	{
    		$('#ifnotify-warning').text(' Please enter amount to pay');
    		$('#ifnotify-warning').trigger('click');
    		return false;
    	}
    	if(pamount>amount)
    	{
    		$('#ifnotify-warning').text(' Amount must be less or equal last payment');
    		$('#ifnotify-warning').trigger('click');
    		return false;
    	}
    	var invoice = $('#invoice_number').text();
       $.ajax({
    		url:base_url+'employees/make_employees_payments',
    		type:'POST',
    		data:{invoice:invoice,pamount:pamount},
    		success:function(msg)
    		{
    			$('#ptext').val('');
    			var res = $.parseJSON(msg);
    			if(res[0]!=0)
    			{
    				$.ajax({
    					url:base_url+'employees/get_employees_payments',
    					type:'POST',
    					data:{invoice:invoice,amount:famount,sadv:'yes'},
    					success:function(msg)
    					{
    						var res = $.parseJSON(msg);
    						$('#payment-tbody').html("");
    						$('#payment-tbody').html('<tr><td></td><td></td><td class="pamount">'+famount+'</td></tr>');
    						if(!isNaN(advance))
    						{
    							$('#payment-tbody').append('<tr><td></td><td class="adv">'+advance+'</td><td class="pamount">'+eval(famount-advance)+'</td></tr>');
    						}
    						$('#payment-tbody').append(res[0]);
    						recalcId();
    					}	
    				});
    			}
    		}
    	});
    });
});// End Ready Function

