<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Suppliers extends Model
{
    protected $table = 'suppliers';
    protected $primaryKey = 'spl_id';
    protected $fillable =['spl_name','spl_address','spl_contact','spl_email','spl_notes','in_user','dated'];
    public $timestamps = false;

    /**
     * Get all purchases for the supplier.
     */
    public function purchases()
    {
        return $this->hasMany(Purchases::class,'spl_id','spl_id');
    }
}
