<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StockItems extends Model
{
    protected $primaryKey = 'stk_id';
    protected $table = 'stock_items';
    public $timestamps = false;
    protected $fillable = [
        'stk_category',
        'stk_barcode',
        'stk_name',
        'stk_pprice',
        'stk_pdate',
        'stk_provider',
        'stk_sprice_b1',
        'stk_sprice_b2',
        'stk_sprice_b3',
        'stk_qty',
        'stk_notify',
        'stk_notes',
        'stk_status',
        'dated',
        'in_user'
    ];


    public function category()
    {
        return $this->belongsTo(StockCategoryItems::class, 'stk_category', 'category_id');
    }

    public function stockIn()
    {
        return $this->hasMany(StockIn::class, 'stk_item', 'stk_barcode');
        //                                       ^foreign key     ^owner key
    }
    public function stockOut()
    {
        return $this->hasMany(StockOut::class, 'stk_item', 'stk_barcode');
        //                                       ^foreign key     ^owner key
    }
    public function stockRemoved()
    {
        return $this->hasMany(StockRemoved::class, 'stk_item', 'stk_barcode');
        //                                       ^foreign key     ^owner key
    }
}
