<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuotationDetails extends Model
{
    protected $table = 'quotation_details';
    public $timestamps = false;
    protected $fillable = [
        'branch_id',
        'invoice',
        'item_name',
        'item_pprice',
        'item_price',
        'item_qty',
        'item_total',
        'dated',
    ];
    public function quotation()
    {
        return $this->belongsTo(Quotations::class, 'invoice', 'invoice');
    }
}
