<?php

namespace App\Http\Controllers;

use App\Models\Customers;
use App\Models\Sales;
use App\Models\SalesDetails;
use App\Models\SalesPayments;
use Illuminate\Http\Request;

class CustomerController extends Controller
{
    public function index()
	{
		return view('customers');
	}
	
	public function show_customers()
	{
		$sno=0;
        $query = Customers::orderBy('customer_id', 'DESC')->get();
		if($query->count()>0)
		{
			foreach($query as $rows)
			{
				$sno++;
				$total_sales=0;
				$total_paid=0;
                $q = Sales::where('customer_id', $rows->customer_id)->get();
				if($q->count()>0)
				{
					foreach($q as $r)
					{
						$total_sales +=$r->grand_total;
                        $pq = SalesPayments::where('invoice', $r->invoice)->get();
						if($pq->num_rows()>0)
						{

						 foreach($pq->result() as $pr)
						 {
						   $total_paid +=$pr->amount;
						 }
						}
					}
				}
				$remaining = ($total_sales-$total_paid);
				$json[]= array(
							$sno,
							$rows->customer_name,
							$rows->customer_contact,
							$rows->customer_email,
							$rows->customer_address,
							$rows->customer_notes,
							$remaining,
		                  '<a href="#" data-toggle="modal" data-target="#customer-invoices-modal" class="text-success" id="'.$rows->customer_id.'" title="Make Payment"><i class="fa fa-tasks"></i></a> &nbsp;'.
		                  '<a href="#" data-toggle="modal" data-target="#customer-edit-modal" class="text-warning"  id="'.$rows->customer_id.'" title=" Edit"><i class="fa fa-pencil"></i></a> &nbsp;'.
	                      '<a href="'.base_url('customers/delete_customer/'.$rows->customer_id).'" class="text-danger ifdel" title="Delete"><i class="fa fa-trash"></i></a>',
						);     
			}
			$response = array();
			$response['success'] = true;
			$response['aaData'] = $json;
			echo json_encode($response);
		}
		else
		{
			$response = array();
			$response['sEcho'] = 0;
			$response['iTotalRecords'] = 0;
			$response['iTotalDisplayRecords'] = 0;
			$response['aaData'] = [];
			echo json_encode($response);
		}
	}
	
	public function add_customers(Request $request)
	{
		$valid_flag  	  = 0;
		$customer_name    = $request->cus_name;
		$customer_contact = $request->cus_contact;
		$customer_email   = $request->cus_email;
		$customer_address = $request->cus_address;
		$customer_notes   = $request->cus_notes;
        $query = Customers::where('customer_contact', $customer_contact)->get();
		if($query->count()==1)
		{
			echo 2;
			exit;
		}
        $ins_array = [
            'customer_name' => $customer_name,
            'customer_contact' => $customer_contact,
            'customer_email' => $customer_email,
            'customer_address' => $customer_address,
            'customer_notes' => $customer_notes,
            'dated' => now(),
        ];
        $ins_query = Customers::create($ins_array);
		if($ins_query)
		{
			echo 1;
		}
		else
		{
			echo 0;
		}
	}

	public function get_customers(Request $request)
	{
		$cus_id = $request->cus_id;
		$query = Customers::where('customer_id', $cus_id)->first();
		if($query)
		{
			$rows = $query;
			$customer_name    = $rows->customer_name;
			$customer_contact = $rows->customer_contact;
			$customer_email   = $rows->customer_email;
			$customer_address = $rows->customer_address;
			$customer_notes   = $rows->customer_notes;
			echo json_encode([$customer_name,$customer_contact,$customer_email,$customer_address,$customer_notes]); 
		}
	}

	public function update_customers(Request $request)
	{
		$valid_flag  = 0;
		$customer_id      = $request->cus_id;
		$customer_name 	  = $request->cus_name;
		$customer_contact = $request->cus_contact;
		$customer_email   = $request->cus_email;
		$customer_address = $request->cus_address;
		$customer_notes   = $request->cus_notes;
		
		$this->db->where('customer_id',$customer_id);
		$this->db->where('customer_name',$customer_name);
		$this->db->where('customer_contact',$customer_contact);
		$this->db->where('customer_email',$customer_email);
		$this->db->where('customer_address',$customer_address);
		$this->db->where('customer_notes',$customer_notes);
		$query = $this->db->get('customers');
        $query = Customers::where('customer_id', $customer_id)
            ->where('customer_name', $customer_name)
            ->where('customer_contact', $customer_contact)
            ->where('customer_email', $customer_email)
            ->where('customer_address', $customer_address)
            ->where('customer_notes', $customer_notes)
            ->get();
        if($query->count()==1)  
		{
			echo 2;
		}
		else
		{
            $query = Customers::where('customer_id', '!=', $customer_id)
                ->where('customer_contact', $customer_contact)
                ->get();
            if($query->count()==1)
			{
				echo 3;
				exit;
			}
            $up_array = [
                'customer_name' => $customer_name,
                'customer_contact' => $customer_contact,
                'customer_email' => $customer_email,
                'customer_address' => $customer_address,
                'customer_notes' => $customer_notes,
                'dated' => now(),
            ];
            $up_query = Customers::where('customer_id', $customer_id)->update($up_array);
			if($up_query)
			{
				echo 1;
			}
			else
			{
				echo 0;
			}
		}
	}

	public function delete_customer($customer_id)
	{
        $delete = Customers::where('customer_id', $customer_id)->delete();
        if($delete)     
		{
			$this->session->set_flashdata('smsg','Deleted');
		}
		else
		{
			$this->session->set_flashdata('emsg','Try Again');
		}
		redirect('customers');
	}
	public function get_customer_invoices(Request $request)
	{
		$customer_id  = $request->customer_id;
        $query = Sales::where('customer_id', $customer_id)->get();
		if($query->count()>0)
		{
			$sno = 0;
			$table = '<table class="table">
						<tr>
							<th> Sno </th>
							<th> Invoice # </th>
							<th> Amount </th>
							<th> Paid </th>
							<th> Balance </th>
							<th> Action </th>
							<th> Reprint </th>
							<th> Date/Time</th>
						</tr>';
			foreach($query as $rows)
			{

				 $sno++;
				 $total_paid =0;
                 $pq = SalesPayments::where('invoice', $rows->invoice)->get();
				 if($pq->count()>0)
				 {
				 	foreach($pq as $pr)
				 	{
				 		$total_paid +=$pr->amount;
				 	}
				 }
				 
				 $table .='<tr>
				 			<td>'.$sno.'</td>
				 			<td><a href="#" id="'.$rows->invoice.'" data-toggle="modal" data-target="#sinvoice-details">'.$rows->invoice.'</a></td>
				 			<td>'.$rows->grand_total.'</td>
				 			<td>'.($total_paid+$rows->advance).'</td>
				 			<td>'.($rows->grand_total-($total_paid+$rows->advance)).'</td>
				 			<td><a href="'.$rows->grand_total.'" title="'.$rows->advance.'" data-toggle="modal" data-target="#make-payment-modal" id="'.$rows->invoice.'" dated="'.date('d/m/Y',strtotime($rows->dated)).'" class="text-primary"><i class="fa fa-plus"> Make Payment</i></a></td>
				 			<td><a href="'.base_url('sales/invoice/'.$rows->invoice).'" target="_blank" class="text-info"><i class="fa fa-print"></i></a></td>
				 			<td>'.$rows->dated.'</td>
				 		   </tr>';
			}
			$table .='</table>';
		}
		else
		{
			$table = 'No Invoices for this customers';
		}
		echo json_encode(array($table));
	}
	
	public function get_customer_payments(Request $request)
	{
		$tr=null;
		$invoice = $request->invoice;
		$amount  = $request->amount;
        $query = SalesPayments::where('invoice', $invoice)->orderBy('pay_id', 'ASC')->get();
		if($query->count()>0)
		{
            $q = Sales::where('invoice', $invoice)->first();
			if($q)
			{
				$r = $q->row();
				$advance = $r->advance;
			}
			if($request->sadv)
			{
				$amount = ($amount-$advance);
			}
			foreach($query as $rows)
			{
				$amount = ($amount - $rows->amount);
				$tr .= '<tr>
							<td></td>
							<td class="paid_amount">'.$rows->amount.'</td>
							<td class="pamount">'.$amount.'</td>
							<td>'.date('d/m/Y',strtotime($rows->pdate)).'</td>
							<td><a href="'.base_url('customers/receipt_print/'.$rows->pay_id).'" target="_blank"><i class="fa fa-print"></i></a></td>
							<td class="text-center"><a href="" class="rmv-payment" id="'.$rows->pay_id.'"><i class="fa fa-close"></i></a></td>
						</tr>'; 
			}
		}
		echo json_encode(array($tr));
		
	}	
	
	public function make_customer_payments(Request $request)
	{
		$invoice = $request->invoice;
		$pamount = $request->pamount;
		$pdate   = $request->pdate;
		$ptype   = $request->ptype;
		$pbank   = $request->pbank;
		$pcheq   = $request->pcheq;
		$pdesc   = $request->pdesc;
        $ins_array = [
            'invoice' => $invoice,
            'amount' => $pamount,
            'pdate' => $pdate,
            'ptype' => $ptype,
            'pbank' => $pbank,
            'pcheq' => $pcheq,
            'pdesc' => $pdesc,
            'logedin_user' => null,
            'dated' => now(),
        ];
        $ins_query = SalesPayments::create($ins_array);
		if($ins_query)
		{
			$msg =1;
			$customer_id = Sales::where('invoice',$invoice)->value('customer_id');
			$number = Customers::where('customer_id',$customer_id)->value('customer_contact');
			$name = Customers::where('customer_id',$customer_id)->value('customer_name');
		}
		else
		{
			$msg=0;
		}
		echo json_encode([$msg]);
	}

	public function remove_payments(Request $request)
	{
		$pay_id = $request->pay_id;
        $delete = SalesPayments::where('pay_id', $pay_id)->delete();
		if($delete)
		{
			$msg =1;
		}
		else
		{
			$msg=0;
		}
		echo json_encode([$msg]);
	}
	public function get_invoice_details(Request $request)
	{

		$invoice = $request->inovoice;
		$table='';
        $query = SalesDetails::where('invoice', $invoice)->get();
		if($query->count()>0)
		{
			$sno=0;
			$total=0;
			$table = '<table>
					   <tr>
					   		<th colspan="5"> SERVICES </th>
					   </tr>
					   <tr>
					   		<th>Sno.</th>
					   		<th>Service</th>
					   		<th>Price</th>
					   		<th>Quantity</th>
					   		<th>Total</th>
					   </tr>';
			foreach($query as $rows)
			{
				$sno++;
				$table .='<tr>
							<td>'.$sno.'</td>
							<td>'.$rows->item_name.'</td>
							<td>'.$rows->item_price.'</td>
							<td>'.$rows->item_qty.'</td>
							<td>'.$rows->item_total.'</td>
						  </tr>';
				$total +=$rows->item_total;
			}
			$table .='<tr>
						<th colspan="4">TOTAL</th>
						<th>'.$total.'</th>
					  </tr>
					</table>';
		}

		

		echo json_encode([$table]);		
	}

	public function receipt($invoice)
	{
		$amount=0;
		$pay_id=0;
		$pdate =null;
		$ptype  = null;
		$pbank  = null;
		$pcheq  = null;
		$pdesc  = null;
		$customer_id = Sales::where('invoice',$invoice)->value('customer_id');
		$customer_name = Customers::where('customer_id',$customer_id)->value('customer_name');
        $q = SalesPayments::where('invoice', $invoice)->orderBy('pay_id', 'DESC')->first();
		if($q)
		{
			$r = $q;
			$amount = $r->amount;
			$pay_id = $r->pay_id;
			$pdate  = $r->pdate;
			$ptype  = $r->ptype;
			$pbank  = $r->pbank;
			$pcheq  = $r->pcheq;
			$pdesc  = $r->pdesc;
		}
		if($ptype=='cheque')
		{
			$data['pbank']  = $pcheq;
		}
		else
		{
			$data['pbank']  = strtoupper(str_replace('_',' ',$pbank));
		}
		$data['ptype']  = strtoupper($ptype);
		$data['pcheq']  = $pcheq;
		$data['pdesc']  = $pdesc;
		$data['pdate'] = $pdate;
		$data['pay_id']=$pay_id;
		$data['customer_name']=$customer_name;
		$data['amount']=$amount;
		return view('receipt',$data);
	}
	public function receipt_print($pay_id,$sales=null)
	{
		$amount=0;
		$pdate =null;
		$ptype  = null;
		$pbank  = null;
		$pcheq  = null;
		$pdesc  = null;
		if($sales!=null)
		{
			$invoice = $pay_id;
		}
		else
		{
			$invoice =SalesPayments::where('pay_id',$pay_id)->value('invoice');
		}
		$customer_id = Sales::where('invoice',$invoice)->value('customer_id');
		$customer_name = Customers::where('customer_id',$customer_id)->value('customer_name');
		if($sales!=null)
		{
            $q = Sales::where('invoice', $pay_id)->first();
			if($q)
			{
				$r = $q;
				$amount = $r->advance;
				$pdate  = $r->sales_date;
				$ptype  = $r->ptype;
				$pbank  = $r->pbank;
				$pcheq  = $r->pcheq;
				$pdesc  = $r->pdesc;
			}
		}
		else
		{
            $q = SalesPayments::where('pay_id', $pay_id)->get();
			if($q->count()==1)
			{
				$r = $q;
				$amount = $r->amount;
				$pdate  = $r->pdate;
				$ptype  = $r->ptype;
				$pbank  = $r->pbank;
				$pcheq  = $r->pcheq;
				$pdesc  = $r->pdesc;
			}
		}	

		if($ptype=='cheque')
		{
			$data['pbank']  = $pcheq;
		}
		else
		{
			$data['pbank']  = strtoupper(str_replace('_',' ',$pbank));
		}
		$data['ptype']  = strtoupper($ptype);
		$data['pdesc']  = $pdesc;
		$data['pdate']  = $pdate;
		$data['pay_id'] =$pay_id;
		$data['customer_name']=$customer_name;
		$data['amount']=$amount;
		if($sales!=null)
		{
			return view('sreceipt',$data);
		}
		else
		{
			return view('receipt',$data);
		}	
	}
	public function receipt_download($pay_id)
	{
		$amount=0;
		$pdate =null;
		$ptype  = null;
		$pbank  = null;
		$pcheq  = null;
		$pdesc  = null;
		$invoice     = SalesPayments::where('pay_id',$pay_id)->value('invoice');
		$customer_id = Sales::where('invoice',$invoice)->value('customer_id');
		$customer_name = Customers::where('customer_id',$customer_id)->value('customer_name');
        $q = SalesPayments::where('pay_id', $pay_id)->get();
		if($q->count()==1)
		{
			$r = $q;
			$amount = $r->amount;
			$pdate  = $r->pdate;
			$ptype  = $r->ptype;
			$pbank  = $r->pbank;
			$pcheq  = $r->pcheq;
			$pdesc  = $r->pdesc;
		}
		if($ptype=='cheque')
		{
			$data['pbank']  = $pcheq;
		}
		else
		{
			$data['pbank']  = strtoupper(str_replace('_',' ',$pbank));
		}
		$data['ptype']  = strtoupper($ptype);
		$data['pdesc']  = $pdesc;
		$data['pdate']  = $pdate;
		$data['pay_id'] =$pay_id;
		$data['customer_name']=$customer_name;
		$data['amount']=$amount;

		// $html = $this->load->view('receipt',$data,TRUE);
	    // $this->load->library('m_pdf');
		// $this->m_pdf->pdf->WriteHTML($html);
		// $this->m_pdf->pdf->Output('RECEIPT-'.$pay_id.'.pdf', "D");
	}
	public function receipt_email(Request $request)
	{
		$pay_id = $request->invoice;
		$amount=0;
		$pdate =null;
		$ptype  = null;
		$pbank  = null;
		$pcheq  = null;
		$pdesc  = null;
        $invoice = SalesPayments::where('pay_id',$pay_id)->value('invoice');
        $customer_id = Sales::where('invoice',$invoice)->value('customer_id');
        $customer_name = Customers::where('customer_id', $customer_id)->value('customer_name');
		$customer_email = Customers::where('customer_id',$customer_id)->value('customer_email');
        $q = SalesPayments::where('pay_id', $pay_id)->get();
		if($q->count()==1)
		{
			$r = $q;
			$amount = $r->amount;
			$pdate  = $r->pdate;
			$ptype  = $r->ptype;
			$pbank  = $r->pbank;
			$pcheq  = $r->pcheq;
			$pdesc  = $r->pdesc;
		}
		if($ptype=='cheque')
		{
			$data['pbank']  = $pcheq;
		}
		else
		{
			$data['pbank']  = strtoupper(str_replace('_',' ',$pbank));
		}
		$data['ptype']  = strtoupper($ptype);
		$data['pdesc']  = $pdesc;
		$data['pdate']  = $pdate;
		$data['pay_id'] =$pay_id;
		$data['customer_name']=$customer_name;
		$data['amount']=$amount;
		// $html = $this->load->view('receipt',$data,TRUE);
	    // $this->load->library('m_pdf');
		// $this->m_pdf->pdf->WriteHTML($html);
		// $this->m_pdf->pdf->Output('./receipts/'.'RECEIPT-'.$pay_id.'.pdf', "F");
		// $config['wordwrap'] = TRUE;
		// $config['mailtype'] = 'html';
		// $this->load->library('email',$config);
		// $this->email->from('info@mazoonadv.com');
		// $this->email->to($customer_email);
		// $this->email->subject('Your Receipt from MazoonAdv');
		// $this->email->message('Please Find The Attached Invoice');
		// $this->email->attach('./receipts/'.'RECEIPT-'.$pay_id.'.pdf');
		// $result = $this->email->send();
		echo $result;
	}
	

}
