<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ExpenseCategoryController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\PurchaseController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\QuotationController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\SalesController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\StockCategoryController;
use App\Http\Controllers\StockItemController;
use App\Http\Controllers\StockTransferController;
use App\Http\Controllers\UserController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/software', function () {
    return view('system');
});

Route::get('/test', function () {
    return view('admin.blank ');
});

Route::get('language/{locale}', function ($locale) {
    if (in_array($locale, config('app.available_locales'))) {
        session()->put('locale', $locale);
    }
    return redirect()->back();
})->name('language');

Route::get('/auth/admin-login', [AuthController::class, 'adminlogin'])->name('auth.admin-login');
Route::post('/auth/login-admin', [AuthController::class, 'loginAdmin'])->name('loginAdmin');
Route::post('/auth/logout-admin', [AuthController::class, 'logoutAdmin'])->name('logoutAdmin');

Route::get('/auth/branch-login', [AuthController::class, 'branchlogin'])->name('auth.branch-login');
Route::post('/auth/login-branch', [AuthController::class, 'loginBranch'])->name('loginBranch');
Route::post('/auth/logout-branch', [AuthController::class, 'logoutBranch'])->name('logoutBranch');

Route::prefix('admin')->middleware(['check.session'])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');

    Route::get('/quotations', [QuotationController::class, 'index'])->name('quotations');
    Route::post('/quotations/get-customer', [QuotationController::class, 'getCustomer'])->name('quotations.get-customer');
    Route::get('/quotations/search-prd', [QuotationController::class, 'search_prd']);
    Route::post('/quotations/add_items_to_list', [QuotationController::class, 'add_items_to_list']);
    Route::get('/quotations/show_stock_items', [QuotationController::class, 'show_stock_items']);
    Route::post('/quotations/process-items', [QuotationController::class, 'processItems'])->name('quotations.process-items');
    Route::get('/quotations/invoice/{id}', [QuotationController::class, 'invoice'])->name('quotations.invoice');


    Route::get('/suppliers', [SupplierController::class, 'index'])->name('suppliers');
    Route::get('/suppliers/show', [SupplierController::class, 'show']);
    Route::post('/suppliers/add', [SupplierController::class, 'add']);
    Route::post('/suppliers/edit', [SupplierController::class, 'edit']);
    Route::post('/suppliers/update', [SupplierController::class, 'update']);
    Route::post('/suppliers/delete', [SupplierController::class, 'delete']);
    Route::post('/suppliers/get-invoices', [SupplierController::class, 'getInvoices'])->name('suppliers.get-invoices');
    Route::post('/suppliers/get-payments', [SupplierController::class, 'getPayments'])->name('suppliers.get-payments');
    Route::post('/suppliers/make-payments', [SupplierController::class, 'makePayments'])->name('suppliers.make-payments');
    Route::post('/suppliers/remove-payments', [SupplierController::class, 'removePayments'])->name('suppliers.remove-payments');

    Route::get('/purchases', [PurchaseController::class, 'index'])->name('purchases');
    Route::get('/purchases/show', [PurchaseController::class, 'show']);
    Route::post('/purchases/invoice-details', [PurchaseController::class, 'invoiceDetails'])->name('purchases.invoice-details');
    Route::post('/purchases/invoice-edit-details', [PurchaseController::class, 'invoiceEditDetails'])->name('purchases.invoice-edit-details');
    Route::post('/purchases/details', [PurchaseController::class, 'details'])->name('purchases.details');
    Route::get('/purchases/search-prd', [PurchaseController::class, 'searchPrd'])->name('purchases.search-prd');
    Route::post('/purchases/add-items-to-list', [PurchaseController::class, 'addItemsToList'])->name('purchases.add-items-to-list');
    Route::post('/purchases/process-items', [PurchaseController::class, 'processItems'])->name('purchases.process-items');
    Route::get('/purchases/invoice/{id}', [PurchaseController::class, 'invoice'])->name('purchases.invoice');
    Route::post('/purchases/ac', [PurchaseController::class, 'pur_ac'])->name('purchases.ac');
    Route::post('/purchases/update', [PurchaseController::class, 'update'])->name('purchases.update');
    Route::post('/purchases/get-suppliers', [PurchaseController::class, 'getSuppliers'])->name('purchases.get-suppliers');
    Route::post('/purchases/delete', [PurchaseController::class, 'delete'])->name('purchases.delete');

    Route::get('/stock/category', [StockCategoryController::class, 'index'])->name('stock.category');
    Route::get('/stock/category/show', [StockCategoryController::class, 'show']);
    Route::post('/stock/category/add', [StockCategoryController::class, 'add']);
    Route::post('/stock/category/edit', [StockCategoryController::class, 'edit']);
    Route::post('/stock/category/update', [StockCategoryController::class, 'update']);
    Route::post('/stock/category/delete', [StockCategoryController::class, 'delete']);

    Route::get('/stock/items', [StockItemController::class, 'index'])->name('stock.items');
    Route::get('/stock/items/show', [StockItemController::class, 'show']);
    Route::post('/stock/items/add', [StockItemController::class, 'add']);
    Route::post('/stock/items/edit', [StockItemController::class, 'edit']);
    Route::post('/stock/items/update', [StockItemController::class, 'update']);
    Route::post('/stock/items/delete', [StockItemController::class, 'delete']);
    Route::post('/stock/items/generate_barcode', [StockItemController::class, 'generate_barcode'])->name('stock.items.generate_barcode');

    Route::get('/stock/addition', [StockItemController::class, 'addition'])->name('stock.addition');

    Route::get('/stock/transfer', [StockTransferController::class, 'index'])->name('stock.transfer');
    Route::get('/stock/transfer/show', [StockTransferController::class, 'show'])->name('stock.transfer.show');
    Route::post('/stock/transfer/add_items_to_transfer_list', [StockTransferController::class, 'add_items_to_transfer_list'])->name('stock.transfer.add_items_to_transfer_list');
    Route::post('/stock/transfer/process_transfer_items', [StockTransferController::class, 'process_transfer_items'])->name('stock.transfer.process_transfer_items');
    Route::post('/stock/transfer/details', [StockTransferController::class, 'details'])->name('stock.transfer.details');
    Route::get('/stock/transfer/invoice/{id}', [StockTransferController::class, 'invoice'])->name('stock.transfer.invoice');


    Route::get('/expense/category', [ExpenseCategoryController::class, 'index'])->name('expense.category');
    Route::get('/expense/category/show', [ExpenseCategoryController::class, 'show']);
    Route::post('/expense/category/add', [ExpenseCategoryController::class, 'add']);
    Route::post('/expense/category/edit', [ExpenseCategoryController::class, 'edit']);
    Route::post('/expense/category/update', [ExpenseCategoryController::class, 'update']);
    Route::post('/expense/category/delete', [ExpenseCategoryController::class, 'delete']);

    Route::get('/expense', [ExpenseController::class, 'index'])->name('expenses');
    Route::get('/expense/show', [ExpenseController::class, 'show']);
    Route::post('/expense/add', [ExpenseController::class, 'add']);
    Route::post('/expense/edit', [ExpenseController::class, 'edit']);
    Route::post('/expense/update', [ExpenseController::class, 'update']);
    Route::post('/expense/delete', [ExpenseController::class, 'delete']);

    Route::get('/users', [UserController::class, 'index'])->name('users');
    Route::get('/users/show', [UserController::class, 'show']);
    Route::post('/users/add', [UserController::class, 'add']);
    Route::post('/users/edit', [UserController::class, 'edit']);
    Route::post('/users/update', [UserController::class, 'update']);
    Route::post('/users/delete', [UserController::class, 'delete']);

    Route::get('/report/sales', [ReportController::class, 'sales'])->name('report.sales');
    Route::post('/report/sales', [ReportController::class, 'sales']);
    Route::post('/report/sales-details', [ReportController::class, 'sales_details']);
    Route::get('/report/sales-category', [ReportController::class, 'sales_category'])->name('report.sales-category');
    Route::get('/report/sales-item-by-branch/{branch_id}', [ReportController::class, 'sales_items_by_branch'])->name('report.sales-item-by-branch');
    Route::post('/report/sales-item-by-branch/{branch_id}', [ReportController::class, 'sales_items_by_branch']);
    Route::get('/report/stock-available', [ReportController::class, 'stock_available'])->name('report.stock-available');
    Route::get('/report/stock-zero', [ReportController::class, 'stock_zero'])->name('report.stock-zero');
    Route::get('/report/purchases', [ReportController::class, 'purchases'])->name('report.purchases');
    Route::post('/report/purchases', [ReportController::class, 'purchases']);
    Route::post('/report/purchase-details', [ReportController::class, 'purchase_details']);
    Route::get('/report/stock-in', [ReportController::class, 'stock_in'])->name('report.stock-in');
    Route::post('/report/stock-in', [ReportController::class, 'stock_in']);
    Route::get('/report/stock-out', [ReportController::class, 'stock_out'])->name('report.stock-out');
    Route::post('/report/stock-out', [ReportController::class, 'stock_out']);
    Route::get('/report/stock-removed', [ReportController::class, 'stock_removed'])->name('report.stock-removed');
    Route::post('/report/stock-removed', [ReportController::class, 'stock_removed']);
    Route::get('/report/transfers', [ReportController::class, 'transfers'])->name('report.transfers');
    Route::post('/report/transfers', [ReportController::class, 'transfers']);
    Route::post('/report/transfer-details', [ReportController::class, 'transfer_details']);
    Route::get('/report/expenses', [ReportController::class, 'expenses'])->name('report.expenses');
    Route::post('/report/expenses', [ReportController::class, 'expenses']);
    Route::get('/report/returns', [ReportController::class, 'returns'])->name('report.returns');
    Route::post('/report/returns', [ReportController::class, 'returns']);
    Route::get('/report/quotations', [ReportController::class, 'quotations'])->name('report.quotations');
    Route::post('/report/quotations', [ReportController::class, 'quotations']);
    Route::post('/report/quotation-details', [ReportController::class, 'quotation_details']);
    Route::get('/report/special', [ReportController::class, 'special'])->name('report.special');
    Route::post('/report/special', [ReportController::class, 'special']);
});


Route::middleware(['check.session'])->group(function () {
    Route::get('/sales', [SalesController::class, 'index'])->name('sales');
    Route::get('/sales/search-prd', [SalesController::class, 'search_prd'])->name('sales.search-prd');
    Route::post('/sales/add-items-to-list', [SalesController::class, 'add_items_to_list'])->name('sales.add-items-to-list');
    Route::post('/sales/process-items', [SalesController::class, 'process_items'])->name('sales.process-items');
    Route::get('/sales/show-stock-items', [SalesController::class, 'show_stock_items'])->name('sales.show-stock-items');
    Route::get('/sales/invoice/{id}', [SalesController::class, 'invoice'])->name('sales.invoice');
    Route::get('/sales/quotations', [SalesController::class, 'quotations'])->name('sales.quotations');
    Route::post('/sales/get-rmd-notes', [SalesController::class, 'get_rmd_notes'])->name('sales.get-rmd-notes');
    Route::post('/sales/save-rmd-notes', [SalesController::class, 'save_rmd_notes'])->name('sales.save-rmd-notes');
    Route::get('/sales/last-invoice', [SalesController::class, 'last_invoice'])->name('sales.last-invoice');
});
