@extends('admin.template.master')
@section('content')
        
<div class="row">
    <div class="col-md-4">
        <label class="form-label" for="stk_category">{{__('messages.category')}}</label>
        <select class="form-control" name="stk_category" id="stk_category">
            <option value="" selected>{{__('messages.choose')}} </option>
            @foreach ($categories as $cat)
                <option value="{{ $cat->category_id }}">{{ $cat->category_name }}</option>
            @endforeach

        </select>
    </div>
    <div class="col-md-4">
        <label class="form-label">{{__('messages.barcode')}} <a href="#" class="genbarcode">[{{__('messages.generate')}}]</a></label>
        <input type="text" name="stk_barcode" id="stk_barcode" class="form-control"
            placeholder="Barcode" />
    </div>
    <div class="col-md-4">
        <label class="form-label">{{__('messages.name')}}</label>
        <input type="text" name="stk_name" id="stk_name" class="form-control" placeholder="Name" />
    </div>
    <div class="col-md-4 d-none">
        <label class="form-label">{{__('messages.purchase_price')}}</label>
        <input type="text" name="stk_pprice" id="stk_pprice" class="form-control isnumber"
            placeholder="Purchase Price" value="0" />
    </div>
    <div class="col-md-4 d-none">
        <label class="form-label">{{__('messages.quantity')}}</label>
        <input type="text" name="stk_qty" id="stk_qty" class="form-control isnumber"
            placeholder="Quantity" value="0" />
    </div>
    <div class="col-md-4">
        <label class="form-label">{{__('messages.selling_price')}} {{__('messages.branch')}} 1</label>
        <input type="text" name="stk_sprice_b1" id="stk_sprice_b1" class="form-control isnumber"
            placeholder="Selling Price" />
    </div>
    <div class="col-md-4">
        <label class="form-label">{{__('messages.selling_price')}} {{__('messages.branch')}} 2</label>
        <input type="text" name="stk_sprice_b2" id="stk_sprice_b2" class="form-control isnumber"
            placeholder="Selling Price" />
    </div>
    <div class="col-md-4">
        <label class="form-label">{{__('messages.selling_price')}} {{__('messages.branch')}} 3</label>
        <input type="text" name="stk_sprice_b3" id="stk_sprice_b3" class="form-control isnumber"
            placeholder="Selling Price" />
    </div>
    <div class="col-md-4 d-none">
        <label class="form-label">Notification Limit</label>
        <input type="text" name="stk_notify" id="stk_notify" class="form-control isnumber"
            placeholder="Notification Limit" value="0" />
    </div>
    <div class="col-md-12">
        <label class="form-label">{{__('messages.notes')}}</label>
        <textarea class="form-control" name="stk_notes" id="stk_notes" style="height:150px;"></textarea>
    </div>

    <div class="col-md-8">
        <button type="button" id="btn-add-stk-items" class="btn btn-success mt-20">{{__('messages.add')}}</button>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <hr>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="table-responsive">
            <table id="stkItemsTable" class="table table-striped table-bordered dt-responsive nowrap"
                style="width:100%;">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('messages.category')}}</th>
                        <th>{{__('messages.barcode')}}</th>
                        <th>{{__('messages.name')}}</th>
                        <th>{{__('messages.last_purchase_price')}}</th>
                        <th>{{__('messages.selling_price')}} {{__('messages.branch')}} 1</th>
                        <th>{{__('messages.selling_price')}} {{__('messages.branch')}} 2</th>
                        <th>{{__('messages.selling_price')}} {{__('messages.branch')}} 3</th>
                        <th>{{__('messages.quantity')}}</th>
                        <th>{{__('messages.notification_limit')}}</th>
                        <th>{{__('messages.notes')}}</th>
                        <th>{{__('messages.actions')}}</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
</div>
           
<div id="stk-item-edit-modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{__('messages.edit')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="form-group col-md-3">
                        <input type="hidden" name="stk_uid" id="e_stk_uid">
                        <label>{{__('messages.category')}}</label>
                        <select class="form-control" name="stk_category" id="e_stk_category" disabled>
                            <option value="" selected>{{__('messages.choose')}} </option>
                            @foreach ($categories as $cat)
                                <option value="{{ $cat->category_id }}">{{ $cat->category_name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-md-3">
                        <label>{{__('messages.barcode')}} <a href="#" id="e_genbarcode">[{{__('messages.generate')}}]</a></label>
                        <input type="text" name="stk_barcode" id="e_stk_barcode" class="form-control"
                            placeholder="Barcode" />
                    </div>
                    <div class="form-group col-md-3">
                        <label>{{__('messages.name')}}</label>
                        <input type="text" name="stk_name" id="e_stk_name" class="form-control"
                            placeholder="Name" />
                    </div>
                    <div class="form-group col-md-3">
                        <label>{{__('messages.purchase_price')}}</label>
                        <input type="text" name="stk_pprice" id="e_stk_pprice" class="form-control"
                            placeholder="Purchase Price" disabled />
                    </div>
                    <div class="form-group col-md-3">
                        <label>{{__('messages.quantity')}}</label>
                        <input type="text" name="stk_qty" id="e_stk_qty" class="form-control isnumber"
                            placeholder="Quantity" disabled />
                    </div>
                    <div class="form-group col-md-3">
                        <label>{{__('messages.selling_price')}} B1</label>
                        <input type="text" name="stk_sprice_b1" id="e_stk_sprice_b1"
                            class="form-control isnumber" placeholder="{{__('messages.selling_price')}}" />
                    </div>
                    <div class="form-group col-md-3">
                        <label>{{__('messages.selling_price')}} B2</label>
                        <input type="text" name="stk_sprice_b2" id="e_stk_sprice_b2"
                            class="form-control isnumber" placeholder="{{__('messages.selling_price')}}" />
                    </div>
                    <div class="form-group col-md-3">
                        <label>{{__('messages.selling_price')}} B3</label>
                        <input type="text" name="stk_sprice_b3" id="e_stk_sprice_b3"
                            class="form-control isnumber" placeholder="{{__('messages.selling_price')}}" />
                    </div>
                    <div class="form-group col-md-2 d-none">
                        <label>{{__('messages.notification_limit')}}</label>
                        <input type="text" name="stk_notify" id="e_stk_notify" class="form-control isnumber"
                            placeholder="Notification Limit" disabled />
                    </div>
                    <div class="form-group col-md-12">
                        <label>{{__('messages.notes')}}</label>
                        <textarea class="form-control" name="stk_notes" id="e_stk_notes" style="height:80px;"></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" id="btn-update-stk-items" class="btn btn-primary">{{__('messages.save_changes')}}</button>
                <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">{{__('messages.close')}}</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
@endsection
@section('customjs')
    <script src="{{ asset('custom_js/stock_items.js') }}"></script>
@endsection
