<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Receipt</title>

    <!-- Normalize or reset CSS with your favorite library -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/7.0.0/normalize.min.css">

    <!-- Load paper.css for happy printing -->
    <!-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/paper-css/0.4.1/paper.css"> -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/paper-css/0.3.0/paper.css">

    <!-- Set page size here: A5, A4 or A3 -->
    <!-- Set also "landscape" if you need -->
    <style>
        @page {
            size: A4
        }
    </style>

    <!-- Custom styles for this document -->
    <link href='https://fonts.googleapis.com/css?family=Roboto' rel='stylesheet' type='text/css'>
    <style>
        body {
            font-family: 'Roboto', serif;
            font-size: 14px;
        }

        th {
            border-bottom: 1px solid black;
        }

        td {
            border-bottom: 1px solid black;
            font-size: 12px;
            padding-top: 10px;
            padding-bottom: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        .text-center {
            text-align: center;
        }

        .text-right {
            text-align: right;
        }
    </style>
    <style>
        @page {
            size: 80mm 210mm
        }

        /* output size */
        body.receipt .sheet {
            width: 80mm;
            height: auto;
            padding: 5mm;
        }

        /* sheet size */

        @media print {
            body.receipt {
                width: 80mm 210mm
            }
        }

        /* fix for Chrome */
    </style>
</head>

<!-- Set "A5", "A4" or "A3" for class name -->
<!-- Set also "landscape" if you need -->

<body class="receipt">
    <section class="sheet">
        <p align="center"><img src="{{ asset('img/logo1.png') }}" style="width:80px;height:80px;"></p>
        <p align="center" style="font-size:10px;margin-right:0px !important;">Date/Time :{{ $dated }}</p>
        <p align="center">Receipt# {{ str_replace('INVOICE', '', $invoice) }} </p>
        <table>
            <tr>
                <th style="font-size:10px;">#</th>
                <th style="width:20px;font-size:10px;">Description</th>
                <th style="text-align:right;font-size:10px;">Price</th>
                <th style="text-align:right;font-size:10px;">Qty</th>
                <th style="text-align:right;font-size:10px;">Total</th>
                <th style="text-align:right;font-size:10px;">Disc%</th>
                <th style="text-align:right;font-size:10px;">Total</th>
            </tr>
            @foreach ($sales_details as $rows)
                <tr>
                    <td style="text-align:center;">{{ $loop->iteration }}</td>
                    <td>{!!str_replace('+', '<br>', $rows->item_name) !!}</td>
                    <td style="text-align:right;">{{ $rows->item_price }}</td>
                    <td style="text-align:right;">{{ $rows->item_qty }}</td>
                    <td style="text-align:right;">{{ $rows->item_total }}</td>
                    <td style="text-align:right;">{{ $rows->item_discount }}</td>
                    <td style="text-align:right;">{{ $rows->item_ftotal }}</td>
                </tr>
            @endforeach
            <tr>
                <td colspan="7">&nbsp;</td>
            </tr>
            <tr>
                <th colspan="6" style="text-align:left;"> SubTotal </th>
                <td style="text-align:right;">{{ $sub_total }} </td>
            </tr>
            <tr>
                <th colspan="6" style="text-align:left;"> Discount </th>
                <td style="text-align:right;">{{ $discount }}</td>
            </tr>
            <tr>
                <th colspan="6" style="text-align:left;"> GrandTotal</th>
                <td style="text-align:right;">{{ $grand_total }}</td>
            </tr>
            <tr>
                <th colspan="6" style="text-align:left;"> Paid</th>
                <td style="text-align:right;">{{ $payments }}</td>
            </tr>
            <tr>
                <th colspan="6" style="text-align:left;"> Change</th>
                <td style="text-align:right;">{{ $grand_total - $payments }}</td>
            </tr>
        </table>
        <p>

        </p>
        <hr>
        <p class="text-center">Thank you for shopping with us!</p>
    </section>
    <script>
        //window.print();//window.close();
    </script>
</body>

</html>
