@extends('admin.template.master')
@section('content')
<div class="row">
    <div class="col-md-12">
        <table class="table" id="stockZeroTable">
            <thead>
              <tr>
                   <th> # </th>
                   <th> {{__('messages.category')}} </th>
                   <th> {{__('messages.barcode')}} </th>
                   <th> {{__('messages.items')}} </th>
                    @foreach($branch_ids as $branch)
                        <th>{{ $branch->branch_name }}</th>
                    @endforeach
                   <th>Branch</th>
              </tr>
            </thead>
            <tbody>
               @foreach($stock_data as $index => $item)
                     <tr>
                        <td>{{$index + 1}}</td>
                        <td>{{$item['stk_category_name']}}</td>
                        <td>{{$item['stk_barcode']}}</td>
                        <td>{{$item['stk_name']}}</td>
                        @foreach($branch_ids as $branch)
                            <td>{{ $item['branches_qty'][$branch->branch_id] ?? null}}</td>
                        @endforeach
                        <td>{!!$item['branches_txt']!!}</td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
              
            </tfoot>
        </table>
    </div>
</div>
@endsection
@section('customjs')
    <script src="{{ asset('custom_js/reports.js') }}"></script>
@endsection
