@extends('admin.template.master')
@section('content')
<div class="row">
    <div class="col-md-12">
        <table class="table MyTable">
            <thead>
              <tr>
                   <th> # </th>
                   <th> {{__('messages.category')}} </th>
                   <th> {{__('messages.barcode')}} </th>
                   <th> {{__('messages.items')}} </th>
                   <th> {{__('messages.admin')}}</th>
                    @foreach($branch_ids as $branch)
                        <th>{{ $branch->branch_name }}</th>
                    @endforeach
                   <th> {{__('messages.purchase_price')}} </th>
                   <th> {{__('messages.sales_price')}}</th>
                   <th>{{__('messages.percentage')}}</th>
              </tr>
            </thead>
            <tbody>
                @foreach($stock_data as $index => $item)
                     <tr>
                        <td>{{$index + 1}}</td>
                        <td>{{$item['stk_category_name']}}</td>
                        <td>{{$item['stk_barcode']}}</td>
                        <td>{{$item['stk_name']}}</td>
                        <td>{{str_replace(',','',number_format($item['stk_qty'],0))}}</td>
                        @foreach($branch_ids as $branch)
                            <td>{{ $item['branches_qty'][$branch->branch_id] ?? null}}</td>
                        @endforeach
                        <td>{{$item['stk_pprice']}}</td>
                        <td>{{$item['stk_sprice_b1']}}</td>
                        <td>{{ $item['margin_percent'] }}%</td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
            </tfoot>
          </table>
    </div>
</div>
@endsection
@section('customjs')
    <script src="{{ asset('custom_js/reports.js') }}"></script>
@endsection
