@extends('admin.template.master')
@section('content')
<form action="{{ route('report.sales-item-by-branch', $branch_id) }}" method="POST">
    <div class="row">
        <div class="col-sm-6">
            @csrf
            <div class="row">
                <div class="form-group col-md-4">
                    <label>{{__('messages.start_date')}}</label>
                    <input type="text" class="form-control datepickr" name="sdate"
                        value="{{ $sdate }}">
                </div>
                <div class="form-group col-md-4 ">
                    <label>{{__('messages.end_date')}}</label>
                    <input type="text" class="form-control datepickr" name="edate"
                        value="{{ $edate }}">
                </div>
                <div class="col-md-4">
                    <button class="btn btn-primary mt-20" type="submit"> {{__('messages.submit')}}</button>
                </div>
            </div>
        </div>
    </div>
</form>
<div class="row">
    <div class="col-12">
        <hr>
        <br>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <table class="table m-0 MyTable" id="reportExpenseTable">
            <thead>
               <tr>
                 <th>#</th>
                 <th>{{__('messages.category')}}</th>
                 <th>{{__('messages.barcode')}}</th>
                 <th>{{__('messages.items')}}</th>
                 <th>{{__('messages.stock')}}</th>
                 <th>{{__('messages.quantity')}}</th>
               </tr>
            </thead>
            <tbody>
                @foreach($query as $rows)
                    @php
                        $itemProperty = 'item'.$branch_id;
                    @endphp
                    <tr>
                        <td>{{$loop->iteration}}</td>
                        <td>{{$rows->$itemProperty?->category?->category_name??'unknown'}}</td>
                        <td>{{$rows->item_barcode}}</td>
                        <td>{{$rows->$itemProperty->stk_name??'unknown'}}</td>
                        <td>{{$rows->$itemProperty->stk_qty??'unknown'}}</td>
                        <td>{{$rows->item_qty}}</td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
                <th>&nbsp;</th>
            </tfoot>
        </table>
    </div>
</div>
<div id="sinvoice-details" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{__('messages.invoice')}} : <span id="invoice_number"></span></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="sinvoice-mbody">

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">{{__('messages.close')}}</button>
            </div>
        </div>
    </div>
</div>
@endsection
@section('customjs')
    <script src="{{ asset('custom_js/reports.js') }}"></script>
@endsection
