@extends('admin.template.master')
@section('content')
    <div class="row">
        <div class="col-md-4">
            <div class="form-group">
                <label for="category_name_items">{{__('messages.expense_category')}}</label>
                <input type="text" name="category_name_items" id="category_name_items" class="form-control" placeholder="Name" />
            </div>
        </div>
        <div class="col-md-8">
            <button type="button" id="btn-add-category-items" class="btn btn-success mt-20">{{__('messages.add')}}</button>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <table id="categoryTable" class="table table-striped table-bordered dt-responsive nowrap"
                cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('messages.name')}}</th>
                        <th>{{__('messages.actions')}}</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
 
    <div id="expense-category-edit-modal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{__('messages.edit')}}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <input type="hidden" name="hcategory_id" id="hcategory-id">
                            <div class="form-group">
                                <label>{{__('messages.category')}}</label>
                                <input type="text" name="ecategory_name" id="ecategory-name" class="form-control"
                                    placeholder="{{__('messages.category')}}" />
                            </div>
                            <span id="ecat-msg"></span>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">{{__('messages.close')}}</button>
                    <button type="button" id="btn-update-category-items"
                        class="btn btn-primary waves-effect waves-light">{{__('messages.save_changes')}}</button>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('customjs')
    <script src="{{ asset('custom_js/expense_category.js') }}"></script>
@endsection
