<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Expenses extends Model
{
    protected $table = 'expenses';
    public $timestamps = false;
    protected $fillable = [
        'branch_id',
        'category',
        'subcategory',
        'exp_title',
        'exp_date',
        'exp_amount',
        'payment_type',
        'cheque_number',
        'exp_notes',
        'logedin_user',
        'dated',
    ];
    public function branch()
    {
        return $this->belongsTo(Branches::class, 'branch_id','branch_id');
    }
    public function category()
    {
        return $this->belongsTo(ExpenseCategory::class, 'category','category_id');
    }
}