<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Customers extends Model
{
    protected $table = 'customers';
    public $timestamps = false;
    protected $fillable = [
        'customer_name',
        'customer_contact',
        'customer_email',
        'customer_address',
        'customer_notes',
        'dated',
    ];
    public function quotations()
    {
        return $this->hasMany(Quotations::class, 'customer_id', 'customer_id');
    }
}
