<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckSession
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {

        // Determine which login page to redirect to
        if ($request->is('admin/*')) {
            if (!session()->has('username') || session('role') != 'admin') {
                return redirect()->route('auth.admin-login');
            }
        }
        else{
            if (!session()->has('username') || session('role') != 'sales') {
                return redirect()->route('auth.branch-login');
            }
        }
        return $next($request);
    }
}
