<?php

namespace App\Http\Controllers;

use App\Models\StockCategoryItems;
use Illuminate\Http\Request;

class StockCategoryController extends Controller
{
    public function index()
    {
        return view('admin.stock_category');
    }

    public function show()
    {
        $sno = 0;
        $query = StockCategoryItems::orderBy('dated', 'DESC')->get();
        if ($query->count() > 0) {
            foreach ($query as $rows) {
                $sno++;
                $json[] = array(
                    $sno,
                    $rows->category_name,
                    '<a href="#" data-toggle="modal" data-target="#category-items-edit-modal" class="text-warning"  id="' . $rows->category_id . '" title=" Edit"><i class="fas fa-edit"></i></a> &nbsp;' .
                    '<a href="javascript:void(0);" data-uid="'.$rows->category_id.'" class="text-danger ifdel" title="Delete"><i class="fa fa-trash"></i></a>',

                );
            }
            $response = array();
            $response['success'] = true;
            $response['aaData'] = $json;
            echo json_encode($response);
        } else {
            $response = array();
            $response['sEcho'] = 0;
            $response['iTotalRecords'] = 0;
            $response['iTotalDisplayRecords'] = 0;
            $response['aaData'] = [];
            echo json_encode($response);
        }
    }

    public function add(Request $request)
    {
        $validated = $request->validate(
            [
                'category_name' => 'required|unique:stock_category_items,category_name',
            ],
            [
                'spl_contact.required' => 'Category Required',
                'spl_contact.unique' => 'Already Exists',
            ]
        );

        if ($request->ajax()) {
            $spl = new StockCategoryItems();
            $spl->category_name    = $request->category_name;
            $spl->in_user = 'n/a';
            $spl->dated = date('Y-m-d H:i:s');
            if ($spl->save()) {
                return 1;
            } else {
                return 0;
            }
        }
    }

    public function edit(Request $request)
    {
        $category_id = $request->category_id;

        $row = StockCategoryItems::where('category_id', $category_id)->first();
        $category_name    = null;
        if ($row) {
            $category_name    = $row->category_name;
        }

        echo json_encode([
            'category_name' => $category_name,
        ]);
    }

    public function update(Request $request)
    {
        $validated = $request->validate(
            [
                'category_id' => 'required|numeric|exists:stock_category_items,category_id',
                'category_name' => 'required|unique:stock_category_items,category_name,' . $request->category_id . ' ,category_id',
            ],
            [
                'category_name.required' => 'Name Required',
                'category_name.unique' => 'Already Exists.',
            ]
        );

        if ($request->ajax()) {
            $scat = StockCategoryItems::where('category_id', $request->category_id)->first();
            if ($scat) {
                $scat->category_name = $request->category_name;
                $scat->in_user = 'n/a';
                $scat->dated = date('Y-m-d H:i:s');
                if ($scat->save()) {
                    return 1;
                } else {
                    return 0;
                }
            }
        }
    }

    public function delete(Request $request)
    {
         $validated = $request->validate(
            [
                'category_id' => 'required|numeric|exists:stock_category_items,category_id',
            ],
            [
                'category_id.required' => 'Category required',
                'category_id.exists' => 'Category does not exits, please refresh the page and try again',
            ]
        );
         if ($request->ajax()) {
            $del = StockCategoryItems::where('category_id',$request->category_id)->delete();
            if($del){
                return 1;
            }
            else{
                return 0;
            }
         }

    }
}
