<?php
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Http;

if (!function_exists('formatAmount')) {
    function formatAmount($amount, $decimals = 3)
    {
        return number_format($amount, $decimals);
    }
}


if (!function_exists('pageTitle')) {
    function pageTitle($string = null)
    {

        $segments = request()->segments();
        $count =count($segments);

        $required = last($segments);
        $optional =2;

        if($count>3){
            $required = $segments[2];
            $optional = 3;
            // return $required;
            $secondLastSegment = Str::lower($segments[count($segments) - $optional]);
            if($secondLastSegment=='report'){
                return str_replace('-',' ',Str::lower(__('messages.'.$required).' '.__('messages.'.$secondLastSegment)));
            }
        }
        return Str::lower($required);
    }
}


if (!function_exists('dailyQoutes')) {
    function dailyQoutes()
    {
        $response = Http::get('https://zenquotes.io/api/today');
        return $response->json()[0]['q'] ?? '';
    }
}


